/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx.campfire;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.CampfireUI;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class UNUSEDCampfireRitualEffect
extends AbstractGameEffect {
    private static final float DURATION = 5.0f;
    private boolean openedPurgeScreen = false;
    private boolean transformedCard = false;
    private Color screenColor = Color.BLACK.cpy();

    public UNUSEDCampfireRitualEffect() {
        this.duration = 5.0f;
        this.screenColor.a = 0.0f;
        AbstractDungeon.overlayMenu.proceedButton.hide();
    }

    @Override
    public void update() {
        if (!AbstractDungeon.isScreenUp) {
            this.duration -= Gdx.graphics.getDeltaTime();
            this.updateBlackScreenColor();
        }
        if (!this.transformedCard && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            AbstractCard c = AbstractDungeon.gridSelectScreen.selectedCards.get(0);
            AbstractDungeon.player.masterDeck.removeCard(c);
            AbstractDungeon.transformCard(c);
            ++CardCrawlGame.metricData.campfire_rituals;
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            this.transformedCard = true;
            if (AbstractDungeon.getCurrRoom() instanceof RestRoom) {
                ((RestRoom)AbstractDungeon.getCurrRoom()).fadeIn();
            }
        }
        if (this.transformedCard && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.TRANSFORM && AbstractDungeon.transformedCard != null) {
            AbstractDungeon.effectsQueue.add(new ShowCardAndObtainEffect(AbstractDungeon.getTransformedCard(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
        }
        if (this.duration < 2.5f && !this.openedPurgeScreen) {
            this.openedPurgeScreen = true;
            AbstractDungeon.gridSelectScreen.open(AbstractDungeon.player.masterDeck, 1, "Select a card to transform.", false, true);
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onRitual();
            }
        }
        if (this.duration < 0.0f) {
            this.isDone = true;
            if (CampfireUI.hidden) {
                AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
            }
        }
    }

    private void updateBlackScreenColor() {
        this.screenColor.a = this.duration > 3.5f ? Interpolation.fade.apply(0.0f, 1.0f, (5.0f - this.duration) / 1.5f) : (this.duration < 1.0f ? Interpolation.fade.apply(1.0f, 0.0f, 1.0f - this.duration) : 1.0f);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GRID) {
            AbstractDungeon.gridSelectScreen.render(sb);
        }
    }
}

